﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.Integration.VIMT.Vista.Mappers;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class MapToProGetConsultsRequest:FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            //TODO - if the patient and provider station codes are the same (or if there is only a patient side to the appt - aka Store/Forward), then skip this step.  No need to run the Vista Query 2x against the same station or against an empty station.  
            state.ProEcRequest = new GetConsultsforPatientMapper().mapGetConsultRequest(state, Side.Patient);
            var siteNum = state.ProEcRequest.VIMTVIAEMRgcfpReqqueryBeanInfo.VIMTVIAEMRgcfpReqpatientInfo.mcs_localSiteId;
            state.ProLoginRequest = new LoginMapper().GetLoginRequest(state.UserId, siteNum, state.OrganizationServiceProxy);
        }
    }
}
